"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const Native = require("../../Native");
const ByteArray_1 = require("./internal/ByteArray");
const Constants_1 = require("./internal/Constants");
const GenericServerPublicParams_1 = require("./GenericServerPublicParams");
class GenericServerSecretParams extends ByteArray_1.default {
    static generate() {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return GenericServerSecretParams.generateWithRandom(random);
    }
    static generateWithRandom(random) {
        return new GenericServerSecretParams(Native.GenericServerSecretParams_GenerateDeterministic(random));
    }
    constructor(contents) {
        super(contents, Native.GenericServerSecretParams_CheckValidContents);
    }
    getPublicParams() {
        return new GenericServerPublicParams_1.default(Native.GenericServerSecretParams_GetPublicParams(this.contents));
    }
}
exports.default = GenericServerSecretParams;
//# sourceMappingURL=GenericServerSecretParams.js.map